﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace AndroidRemote
{
	public partial class Form1 : Form
	{
		private Boolean flgTimer = false;
		public static Boolean flgUpdated = false;

		public Form1()
		{
			InitializeComponent();
			panel1.AutoScroll = true;

		}

		private void Form1_FormClosed(object sender, FormClosedEventArgs e)
		{
			appicationEnd();
		}

		private void exitToolStripMenuItem_Click(object sender, EventArgs e)
		{
			appicationEnd();
		}

		public void appicationEnd()
		{
			if (pictureBoxScreen.Image != null)
			{
				pictureBoxScreen.Image.Dispose();
			}

			if (flgTimer == true)
			{
				timerAutoCapture.Stop();
			}

			//アプリケーションを終了する
			Application.Exit();
		}

		private void captureToolStripMenuItem1_Click(object sender, EventArgs e)
		{
			captureDelegate func = new captureDelegate(captureScreen);
			func(this, this.pictureBoxScreen);

		}

		private void autoToolStripMenuItem_Click(object sender, EventArgs e)
		{
			if (autoToolStripMenuItem.Checked == true)
			{
				autoToolStripMenuItem.Checked = false;
			}
			else
			{
				autoToolStripMenuItem.Checked = true;
				timerAutoCapture.Interval = 5000;

			}

			if (autoSync10SecToolStripMenuItem.Checked == true)
			{
				autoSync10SecToolStripMenuItem.Checked = false;
			}
			changeCheck(0);
		}

		private void autoSync10SecToolStripMenuItem_Click(object sender, EventArgs e)
		{
			if (autoSync10SecToolStripMenuItem.Checked == true)
			{
				autoSync10SecToolStripMenuItem.Checked = false;
			}
			else
			{
				autoSync10SecToolStripMenuItem.Checked = true;
				timerAutoCapture.Interval = 10000;
			}

			if (autoToolStripMenuItem.Checked == true)
			{
				autoToolStripMenuItem.Checked = false;
			}
			changeCheck(0);
		}

		private void changeCheck(int value)
		{
			if (flgTimer == true)
			{
				flgTimer = false;
				timerAutoCapture.Stop();
			}
			else
			{
				flgTimer = true;
				timerAutoCapture.Start();
			}
		}

		private void timerAutoCapture_Tick(object sender, EventArgs e)
		{
			captureDelegate func = new captureDelegate(captureScreen);
			func(this, this.pictureBoxScreen);

		}

		delegate void captureDelegate(Form form, PictureBox target);
		static void captureScreen(Form form, PictureBox target)
		{
			// ●プロセス起動情報の構築
			System.Diagnostics.ProcessStartInfo startInfo = new System.Diagnostics.ProcessStartInfo();

			// バッチファイルを起動する人は、cmd.exeさんなので
			startInfo.FileName = "cmd.exe";

			// コマンド処理実行後、コマンドウィンドウ終わるようにする。
			//（↓「/c」の後の最後のスペース1文字は重要！）
			startInfo.Arguments = "/c ";

			// コマンド処理であるバッチファイル （ここも最後のスペース重要）
			startInfo.Arguments += @"bat\\capture.bat ";

			// バッチファイルへの引数 
			startInfo.Arguments += "";

			// 非表示
			startInfo.CreateNoWindow = true;
			startInfo.UseShellExecute = false;

			// ●バッチファイルを別プロセスとして起動
			var proc = System.Diagnostics.Process.Start(startInfo);

			// ●上記バッチ処理が終了するまで待ちます。
			proc.WaitForExit();

			//画像ファイルを読み込んで、Imageオブジェクトを作成する
			System.Drawing.Image img = CreateImage(@"tmp.png");

			//画像を表示する
			if (target.Image != null)
			{
				target.Image.Dispose();
			}

			if (img != null)
			{
				target.Image = img;
				if (flgUpdated == false)
				{
					flgUpdated = true;
					form.Size = img.Size;
				}
			}
		}
		/// <summary>
		/// 指定したファイルをロックせずに、System.Drawing.Imageを作成する。
		/// </summary>
		/// <param name="filename">作成元のファイルのパス</param>
		/// <returns>作成したSystem.Drawing.Image。</returns>
		public static System.Drawing.Image CreateImage(string filename)
		{
			try
			{
				System.IO.FileStream fs = new System.IO.FileStream(
					filename,
					System.IO.FileMode.Open,
					System.IO.FileAccess.Read);
				System.Drawing.Image img = System.Drawing.Image.FromStream(fs);
				fs.Close();
				return img;
			}
			catch
			{
			}
			return null;
		}

		delegate void clickDelegate(int px, int py);
		private void pictureBoxScreen_Click(object sender, EventArgs e)
		{
			//フォーム上の座標でマウスポインタの位置を取得する
			//画面座標でマウスポインタの位置を取得する
			System.Drawing.Point sp = System.Windows.Forms.Cursor.Position;
			//画面座標をクライアント座標に変換する
			System.Drawing.Point cp = pictureBoxScreen.PointToClient(sp);
			//X座標を取得する
			int x = cp.X;
			//Y座標を取得する
			int y = cp.Y;

			clickDelegate func = new clickDelegate(clickScreen);
			func(x, y);
		}
		static void clickScreen(int px, int py)
		{
			// ●プロセス起動情報の構築
			System.Diagnostics.ProcessStartInfo startInfo = new System.Diagnostics.ProcessStartInfo();

			// バッチファイルを起動する人は、cmd.exeさんなので
			startInfo.FileName = "cmd.exe";

			// コマンド処理実行後、コマンドウィンドウ終わるようにする。
			//（↓「/c」の後の最後のスペース1文字は重要！）
			startInfo.Arguments = "/c ";

			// コマンド処理であるバッチファイル （ここも最後のスペース重要）
			startInfo.Arguments += @"bat\\tap.bat ";

			// バッチファイルへの引数 
			startInfo.Arguments += px + " " + py;

			// 非表示
			startInfo.CreateNoWindow = true;
			startInfo.UseShellExecute = false;

			// ●バッチファイルを別プロセスとして起動
			var proc = System.Diagnostics.Process.Start(startInfo);

			// ●上記バッチ処理が終了するまで待ちます。
			proc.WaitForExit();
		}

		delegate void sendKeyDelegate(int code);
		private void homeToolStripMenuItem_Click(object sender, EventArgs e)
		{
			sendKeyDelegate func = new sendKeyDelegate(sendKey);
			func(3);
		}

		private void backToolStripMenuItem_Click(object sender, EventArgs e)
		{
			sendKeyDelegate func = new sendKeyDelegate(sendKey);
			func(4);
		}

		private void menuToolStripMenuItem_Click(object sender, EventArgs e)
		{
			sendKeyDelegate func = new sendKeyDelegate(sendKey);
			func(82);
		}

		private void volumeUpToolStripMenuItem_Click(object sender, EventArgs e)
		{
			sendKeyDelegate func = new sendKeyDelegate(sendKey);
			func(24);

		}

		private void volumeDownToolStripMenuItem_Click(object sender, EventArgs e)
		{
			sendKeyDelegate func = new sendKeyDelegate(sendKey);
			func(25);

		}

		private void volumeMuteToolStripMenuItem_Click(object sender, EventArgs e)
		{
			sendKeyDelegate func = new sendKeyDelegate(sendKey);
			func(164);
		}

		static void sendKey(int code)
		{
			// ●プロセス起動情報の構築
			System.Diagnostics.ProcessStartInfo startInfo = new System.Diagnostics.ProcessStartInfo();

			// バッチファイルを起動する人は、cmd.exeさんなので
			startInfo.FileName = "cmd.exe";

			// コマンド処理実行後、コマンドウィンドウ終わるようにする。
			//（↓「/c」の後の最後のスペース1文字は重要！）
			startInfo.Arguments = "/c ";

			// コマンド処理であるバッチファイル （ここも最後のスペース重要）
			startInfo.Arguments += @"bat\\sendKeyCode.bat ";

			// バッチファイルへの引数 
			startInfo.Arguments += code;

			// 非表示
			startInfo.CreateNoWindow = true;
			startInfo.UseShellExecute = false;

			// ●バッチファイルを別プロセスとして起動
			var proc = System.Diagnostics.Process.Start(startInfo);

			// ●上記バッチ処理が終了するまで待ちます。
			proc.WaitForExit();
		}

		private void user1ToolStripMenuItem_Click(object sender, EventArgs e)
		{
			runBatDelegate func = new runBatDelegate(runBat);
			func("bat\\user1.bat");
		}

		private void user2ToolStripMenuItem_Click(object sender, EventArgs e)
		{
			runBatDelegate func = new runBatDelegate(runBat);
			func("bat\\user1.bat");

		}

		delegate void runBatDelegate(String fileName);
		static void runBat(String fileName)
		{
			// ●プロセス起動情報の構築
			System.Diagnostics.ProcessStartInfo startInfo = new System.Diagnostics.ProcessStartInfo();

			// バッチファイルを起動する人は、cmd.exeさんなので
			startInfo.FileName = "cmd.exe";

			// コマンド処理実行後、コマンドウィンドウ終わるようにする。
			//（↓「/c」の後の最後のスペース1文字は重要！）
			startInfo.Arguments = "/c ";

			// コマンド処理であるバッチファイル （ここも最後のスペース重要）
			startInfo.Arguments += @"" + fileName + " ";

			// バッチファイルへの引数 
			startInfo.Arguments += "";

			// 非表示
			startInfo.CreateNoWindow = true;
			startInfo.UseShellExecute = false;

			// ●バッチファイルを別プロセスとして起動
			var proc = System.Diagnostics.Process.Start(startInfo);

			// ●上記バッチ処理が終了するまで待ちます。
			proc.WaitForExit();
		}

		private void helpToolStripMenuItem_Click(object sender, EventArgs e)
		{
			System.Diagnostics.Process.Start("readme.txt");
		}
	}
}
